package music;

import java.util.LinkedList;

public class Playlist {
	
	private LinkedList<Song> songs;
	
	public Playlist(LinkedList<Song> songs) {
		super();
		this.songs = songs;
	}

	public Playlist() {
		super();
		songs = new LinkedList<Song>();
	}
	
	public void add(Song s) {
		songs.add(s);
	}
	
	public void push(Song s) {
		songs.push(s);
	}
	
	public Song pop() {
		return songs.pop();
	}
	
	public Song remove() {
		return songs.remove();
	}
	
	public void playAll() {
		for (int i = 0; i < songs.size(); i++) {
			songs.get(i).display();
		}
	}

	public LinkedList<Song> getSongs() {
		return songs;
	}

	public void setSongs(LinkedList<Song> songs) {
		this.songs = songs;
	}

}
